/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingRecipeBuilder
extends AbstractRecipeBuilder<MeltingRecipeBuilder> {
    private final class_1856 input;
    private final FluidStack output;
    private final int temperature;
    private final int time;
    @Nullable
    private IMeltingContainer.OreRateType oreRate = null;
    @Nullable
    private IMeltingContainer.OreRateType[] byproductRates = null;
    @Nullable
    private long[] unitSizes;
    private final List<FluidStack> byproducts = new ArrayList<FluidStack>();

    public static MeltingRecipeBuilder melting(class_1856 input, FluidStack output, int temperature, int time) {
        if (temperature < 0) {
            throw new IllegalArgumentException("Invalid temperature " + temperature + ", must be greater than zero");
        }
        if (time <= 0) {
            throw new IllegalArgumentException("Invalid time " + time + ", must be greater than zero");
        }
        return new MeltingRecipeBuilder(input, output, temperature, time);
    }

    public static MeltingRecipeBuilder melting(class_1856 input, FluidStack output, float timeFactor) {
        int temperature = FluidVariantAttributes.getTemperature((FluidVariant)output.getType()) - 300;
        return MeltingRecipeBuilder.melting(input, output, temperature, IMeltingRecipe.calcTime(temperature, timeFactor));
    }

    public static MeltingRecipeBuilder melting(class_1856 input, class_3611 fluid, long amount, float timeFactor) {
        return MeltingRecipeBuilder.melting(input, new FluidStack(fluid, amount), timeFactor);
    }

    public static MeltingRecipeBuilder melting(class_1856 input, class_3611 fluid, long amount) {
        return MeltingRecipeBuilder.melting(input, new FluidStack(fluid, amount), IMeltingRecipe.calcTimeFactor(amount));
    }

    public MeltingRecipeBuilder setOre(IMeltingContainer.OreRateType rate, IMeltingContainer.OreRateType ... byproductRates) {
        this.oreRate = rate;
        this.byproductRates = byproductRates.length == 0 ? null : byproductRates;
        return this;
    }

    public MeltingRecipeBuilder setDamagable(long ... unitSizes) {
        this.unitSizes = unitSizes;
        return this;
    }

    public MeltingRecipeBuilder addByproduct(FluidStack fluidStack) {
        this.byproducts.add(fluidStack);
        return this;
    }

    public void save(Consumer<class_2444> consumer) {
        this.save(consumer, class_7923.field_41173.method_10221((Object)this.output.getFluid()));
    }

    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.oreRate != null && this.unitSizes != null) {
            throw new IllegalStateException("Builder cannot be both ore and damagable");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "melting");
        consumer.accept((class_2444)new Result(id, advancementId));
    }

    private MeltingRecipeBuilder(class_1856 input, FluidStack output, int temperature, int time) {
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.time = time;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super((AbstractRecipeBuilder)MeltingRecipeBuilder.this, ID, advancementID);
        }

        public void method_10416(JsonObject json) {
            if (MeltingRecipeBuilder.this.oreRate != null) {
                json.addProperty("rate", MeltingRecipeBuilder.this.oreRate.getName());
            }
            if (!MeltingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", MeltingRecipeBuilder.this.group);
            }
            json.add("ingredient", MeltingRecipeBuilder.this.input.method_8089());
            JsonObject result = RecipeHelper.serializeFluidStack((FluidStack)MeltingRecipeBuilder.this.output);
            if (MeltingRecipeBuilder.this.unitSizes != null) {
                if (MeltingRecipeBuilder.this.unitSizes.length > 0) {
                    result.addProperty("unit_size", (Number)MeltingRecipeBuilder.this.unitSizes[0]);
                } else {
                    result.addProperty("unit_size", (Number)1);
                }
            }
            json.add("result", (JsonElement)result);
            json.addProperty("temperature", (Number)MeltingRecipeBuilder.this.temperature);
            json.addProperty("time", (Number)MeltingRecipeBuilder.this.time);
            if (!MeltingRecipeBuilder.this.byproducts.isEmpty()) {
                JsonArray array = new JsonArray();
                for (int i = 0; i < MeltingRecipeBuilder.this.byproducts.size(); ++i) {
                    IMeltingContainer.OreRateType rate;
                    FluidStack fluidStack = MeltingRecipeBuilder.this.byproducts.get(i);
                    JsonObject byproduct = RecipeHelper.serializeFluidStack((FluidStack)fluidStack);
                    if (MeltingRecipeBuilder.this.unitSizes != null && i <= MeltingRecipeBuilder.this.unitSizes.length) {
                        byproduct.addProperty("unit_size", (Number)MeltingRecipeBuilder.this.unitSizes[i + 1]);
                    } else if (MeltingRecipeBuilder.this.oreRate != null && MeltingRecipeBuilder.this.byproductRates != null && i < MeltingRecipeBuilder.this.byproductRates.length && (rate = MeltingRecipeBuilder.this.byproductRates[i]) != null) {
                        byproduct.addProperty("rate", rate.getName());
                    }
                    array.add((JsonElement)byproduct);
                }
                json.add("byproducts", (JsonElement)array);
            }
        }

        public class_1865<?> method_17800() {
            if (MeltingRecipeBuilder.this.oreRate != null) {
                return (class_1865)TinkerSmeltery.oreMeltingSerializer.get();
            }
            if (MeltingRecipeBuilder.this.unitSizes != null) {
                return (class_1865)TinkerSmeltery.damagableMeltingSerializer.get();
            }
            return (class_1865)TinkerSmeltery.meltingSerializer.get();
        }
    }
}

